# Rule 2.7 A function should not contain unused parameters

## Category

Advisory

## Analysis

Decidable, Single Translation Unit

## Applies to

C90, C99, C11

## Rationale

Most functions will be specified as using each of their parameters. If a function parameter is unused, it is possible that the implementation of the function does not match its specification. This rule highlights such potential mismatches.

## Example

```c
void withunusedpara (uint16_t *para1, int16_t unusedpara) /* Non-compliant - unused */
{
    *para1 = 42U;
}

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
