# Rule 21.18 The size_t argument passed to any function in <string.h> shall have an appropriate value
## Category
Mandatory
## Analysis
Undecidable, System
## Applies to
C90, C99, C11
## Amplification
The relevant functions in `<string.h>` are:
`memchr`, `memcmp`, `memcpy`, `memmove`, `memset`, `strncat`, `strncmp`, `strncpy`, `strxfrm`
An appropriate value is:
- Positive;
- No greater than the size of the smallest object passed to the function through a pointer parameter.
## Rationale
Incorrect use of a function listed above may result in a read or write access beyond the bounds of an object passed as a parameter, resulting in *undefined behaviour*.
## Example
```c
char buf1[ 5 ] = "12345";
char buf2[ 10 ] = "1234567890";

void f ( void )
{ 
 if ( memcmp ( buf1, buf2, 5 ) == 0 ) /* Compliant */
 {
 }
 if ( memcmp ( buf1, buf2, 6 ) == 0 ) /* Non-compliant */
 {
 }
}
```
## See also
Rule 21.17

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
