# Rule 21.20 The pointer returned by the Standard Library functions asctime, ctime, gmtime, localtime, localeconv, getenv, setlocale or strerror shall not be used following a subsequent call to the same function
## Category
Mandatory
## Analysis
Undecidable, System
## Applies to
C90, C99, C11
## Amplification
For the purposes of this rule:
- a call to *setlocale* function following a call to *localeconv* function shall be treated as if they are calls to the same function.
- the *asctime* and *ctime* functions shall be treated as if they are the same function.
- the *gmtime* and *localtime* functions shall be treated as if they are the same function.
## Rationale
The Standard Library functions *asctime*, *ctime*, *gmtime*, *localtime*, *localeconv*, *getenv*, *setlocale* and *strerror* return a pointer to an object within the Standard Library. Implementations are permitted to use static buffers for any of these objects and a second call to the same function may modify the contents of the buffer. The value accessed through a pointer held by the program before a subsequent call to a function may therefore change unexpectedly.
## Example
```c
void f1( void )
{
 const char *res1;
 const char *res2;
 char copy[ 128 ];

 res1 = setlocale ( LC_ALL, 0 );
 ( void ) strcpy ( copy, res1 );
 res2 = setlocale ( LC_MONETARY, "French" );

 printf ( "%s\n", res1 ); /* Non-compliant - use after subsequent call */
 printf ( "%s\n", copy ); /* Compliant - copy made before subsequent call */
 printf ( "%s\n", res2 ); /* Compliant - no subsequent call before use */
}
```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
