# Rule 21.3 The memory allocation and deallocation functions of <stdlib.h> shall not be used
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
The identifiers *calloc*, *malloc*, *realloc*, *aligned_alloc* and *free* shall not be used and no macro with one of these names shall be expanded.
## Rationale
Use of dynamic memory allocation and deallocation routines provided by the Standard Library can lead to undefined behaviour, for example:
- Memory that was not dynamically allocated is subsequently freed;
- A pointer to freed memory is used in any way;
- Accessing allocated memory before storing a value into it.
Note: this rule is a specific instance of Dir 4.12.
## See also
Dir 4.12, Rule 18.7, Rule 22.1, Rule 22.2

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
