# Rule 8.11 When an array with external linkage is declared, its size should be explicitly specified

## Category

Advisory

## Analysis

Decidable, Single Translation Unit

## Applies to

C90, C99, C11

## Amplification

This rule applies to non-defining declarations only. It is possible to define an array and specify its size implicitly by means of initialization. 

## Rationale

Although it is possible to declare an array with incomplete type and access its elements, it is safer to do so when the size of the array may be explicitly determined. Providing size information for each declaration permits them to be checked for consistency. It may also permit a static checker to perform some array bounds analysis without needing to analyse more than one translation unit. 

## Example

```c
extern int32_t array1[ 10 ]; /* Compliant */
extern int32_t array2[ ]; /* Non-compliant */

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
