# Rule 11.5 A conversion should not be performed from pointer to void into pointer to object

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
Conversion of a pointer to *void* into a pointer to object may result in a pointer that is not correctly aligned, resulting in undefined behaviour.

If conversion from a pointer to object into a pointer to *void* is used, care should be taken to ensure that any pointers produced do not give rise to the undefined behaviour discussed under Rule 11.3.

As the C Standard guarantees that the Standard Library dynamic memory allocation functions return pointers that are correctly aligned for each type, the pointers returned by those functions can be safely converted directly into a pointer to object.

## Exception
1.  A *null pointer constant* that has type pointer to *void* may be converted into pointer to object;
2.  The pointer returned by a Standard Library memory allocation function (*malloc*, *calloc*, *realloc* or *aligned_alloc*) may be immediately converted into a pointer to object.

## Example
```c
uint32_t *p32;
void     *p;
uint16_t *p16;

p = p32;                        /* Compliant     - pointer to uint32_t into *
                                 * pointer to void                          */
p16 = p;                        /* Non-compliant */
p = ( void * ) p16;             /* Compliant */
p32 = ( uint32_t * ) p;         /* Non-compliant */
```

The following examples shows that the conversion must be immediate to qualify for the exception:

```c
int  *x  = malloc( sizeof( int ) ); /* Compliant by Exception 2 */
void *p  = malloc( sizeof( int ) );
int  *ip = p;                       /* Non-compliant - conversion not immediate */
```

## See also
Dir 4.12, Rule 11.2, Rule 11.3, Rule 21.3

---

Copyright The MISRA Consortium Limited © [Date - March 2025].