# Rule 11.9 The macro NULL shall be the only permitted form of integer null pointer constant

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
An *integer constant expression* with the value 0 shall be derived from expansion of the macro `NULL` if it appears in any of the following contexts:
*   As the value being *assigned* to a pointer;
*   As an operand of an `==` or `!=` operator whose other operand is a pointer;
*   As the second operand of a `?:` operator whose third operand is a pointer;
*   As the third operand of a `?:` operator whose second operand is a pointer.

Ignoring whitespace and any surrounding parentheses, any such *integer constant expression* shall represent the entire expansion of `NULL`.

Note: a null pointer constant of the form `(void *)0` is permitted, whether or not it was expanded from `NULL`.

## Rationale
Using `NULL` rather than 0 makes it clear that a *null pointer constant* was intended.

## Exception
The initializer `{ 0 }` may be used to initialize an aggregate or union type containing pointers.

## Example
In the following example, the initialization of `p2` is compliant because the *integer constant expression* 0 does not appear in one of the contexts prohibited by this rule.

```c
int32_t *p1 = 0;                /* Non-compliant */

int32_t *p2 = ( void * ) 0;     /* Compliant     */
```

In the following example, the comparison between `p2` and `(void *)0` is compliant because the *integer constant expression* 0 appears as the operand of a cast and not in one of the contexts prohibited by this rule.

```c
#define MY_NULL_1 0
#define MY_NULL_2 ( void * ) 0

if ( p1 == MY_NULL_1 )          /* Non-compliant */
{
}

if ( p2 == MY_NULL_2 )          /* Compliant     */
{
}
```

The following example is compliant because use of the macro `NULL` provided by the implementation is always permitted, even if it expands to an *integer constant expression* with value 0.

```c
#include <stddef.h>             /* To obtain macro NULL */

extern void f ( uint8_t *p );

/* Compliant for any conforming definition of NULL, such as:
 * 0
 * ( void * ) 0
 * ( ( ( 0 ) ) )
 * ( ( ( 1 - 1 ) ) )
 */
f ( NULL );
```

## See also
Rule 11.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].