# Rule 2.5 A project should not contain unused macro definitions

## Category
Advisory

## Analysis
Decidable, System

## Applies to
C90, C99, C11

## Amplification
*#undef* of a macro is considered to be a *use* of a macro.

## Rationale
If a macro is defined but not used, then it is unclear to a reviewer if the macro is redundant or it has been left unused by mistake.

## Example
```c
#define SIZE 4
#define DATA 3    /* Non-compliant - DATA not used */

void use_macro ( void )
{
  use_int16 ( SIZE );
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].