# Rule 21.24 The random number generator functions of `<stdlib.h>` shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
The functions *rand* and *srand* shall not be used and no macro with one of these names shall be expanded.

## Rationale
The C Standard Library function *rand()* makes no guarantees as to the quality of the random sequence produced.

The C Standard warns that the numbers generated by some implementations of the *rand()* function have a short cycle and the results can be predictable. Applications with particular requirements should use a generator that is known to be sufficient for their needs.

The *srand()* function is also included within this rule, as without any associated use of the *rand()* function, its use is superfluous.

## Example
```c
#include <stdlib.h>

int r = rand(); /* Non-compliant */
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].