# Rule 22.17 No thread shall unlock a mutex or call *cnd_wait()* or *cnd_timedwait()* for a mutex it has not locked before

## Category
Required

## Analysis
Undecidable, System

## Applies to
C11

## Amplification
A mutex shall only be unlocked by a thread if it has been locked by that thread before.

The *cnd_wait()* and *cnd_timedwait()* functions shall only be called by a thread on a mutex that is locked by that thread.

## Rationale
Unlocking a mutex which has not been locked by the calling thread is undefined behaviour. Calling *cnd_wait()* or *cnd_timedwait()* with mutex argument *mtx* requires that the mutex pointed to by *mtx* be locked by the calling thread.

## Example
```c
mtx_t Ra;
mtx_t Rb;
cnd_t Cnd1;
cnd_t Cnd2;

int32_t t1( void *ignore ) /* Thread 1 */
{
  mtx_lock ( &Ra );
  mtx_unlock( &Ra );       /* Compliant */
  mtx_unlock( &Ra );       /* Non-compliant - mutex is not locked */

  cnd_wait ( &Cnd1, &Ra ); /* Non-compliant - mutex is not locked */

  mtx_unlock( &Rb);        /* Non-compliant - mutex either not locked, or
                              ... is locked by different thread */

  cnd_wait ( &Cnd2, &Rb ); /* Non-compliant - mutex either not locked, or
                              ... is locked by different thread */
  return 0;
}

int32_t t2( void *ignore ) /* Thread 2 */
{
  mtx_lock ( &Rb );
  doSomething();
  mtx_unlock ( &Rb );      /* Compliant */
  return 0;
}
```

## See also
Dir 4.13, Rule 22.1, Rule 22.18

---

Copyright The MISRA Consortium Limited © [Date - March 2025].