# Rule 7.3 The lowercase character “l” shall not be used in a literal suffix

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Rationale
Using the uppercase suffix “L” removes the potential ambiguity between “1” (digit 1) and “l” (letter “el”) when declaring literals.

## Example
Note: the examples containing the *long long* suffix are applicable only to C99.

```c
const int64_t      a = 0L;
const int64_t      b = 0l;      /* Non-compliant */
const uint64_t     c = 0Lu;
const uint64_t     d = 0lU;     /* Non-compliant */
const uint64_t     e = 0ULL;
const uint64_t     f = 0Ull;    /* Non-compliant */
const int128_t     g = 0LL;
const int128_t     h = 0ll;     /* Non-compliant */ 
const long double  m = 1.2L;
const long double  n = 2.4l;    /* Non-compliant */
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].