# Rule 8.17 At most one explicit alignment specifier should appear in an object declaration

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C11

## Rationale
If the alignment of an object is important, it should be specified explicitly.

Because an *alignment specifier* only places a minimum requirement on the actual alignment of an object, C permits a declaration to contain multiple *alignment specifiers*, with the strictest imposing the final requirement.

If separate conditions require different minimum permitted alignments for an object, they should be combined explicitly by the expression controlling the specifier. Otherwise, the conflicting *alignment specifiers* risk obscuring the intent of the declaration from a human reviewer.

## Example
```c
int32_t a;                                  /* Compliant - no alignment specifier */
alignas(16) int32_t b;                      /* Compliant - one alignment specifier */
alignas(16) alignas(8) int32_t c;           /* Non-compliant - two alignment specifiers */
alignas(16) alignas(0) int32_t d;           /* Non-compliant - also violates Rule 8.16 */
```

The following example shows a way of generating conditional alignment:

```c
#define SML_ALIGN 16
#define BIG_ALIGN 32
alignas(MAX(SML_ALIGN, BIG_ALIGN)) int32_t e; /* Compliant */
```

## See also
Rule 8.15, Rule 8.16

---

Copyright The MISRA Consortium Limited © [Date - March 2025].