# Rule 9.5 Where designated initializers are used to initialize an array object the size of the array shall be specified explicitly

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C99, C11

## Amplification
The rule applies equally to an array subobject that is a flexible array member.

## Rationale
If the size of an array is not specified explicitly, it is determined by the highest index of any of the elements that are initialized. When using designated initializers it may not always be clear which initializer has the highest index, especially when the initializer contains a large number of elements.

To make the intent clear, the array size shall be declared explicitly. This provides some protection if, during development of the program, the indices of the initialized elements are changed as it is a *constraint* violation to initialize an element outside the bounds of an array.

## Example
```c
/* Non-compliant - probably unintentional to have single element */
int32_t a1[ ] = { [ 0 ] = 1 };

/* Compliant */
int32_t a2[ 10 ] = { [ 0 ] = 1 };
```

---

Copyright The MISRA Consortium Limited © [Date - March 2025].