# Dir 1.2 The use of language extensions should be minimized

## Category
Advisory

## Applies to
C90, C99, C11

## Rationale
A program that relies on language extensions may be less portable than one that does not. Although the C Standard requires that a conforming implementation document any extensions that it provides to the language, there is a risk that this documentation might not provide a full description of the behaviour in all circumstances.

If this directive is not applied, the decision to use each language extension should be justified in the project’s design documentation. The methods by which valid use of each extension will be assured, for example checking the compiler and its diagnostics, should also be documented.

It is recognized that it is necessary to use language extensions in embedded systems. The C Standard requires that an extension does not alter the behaviour of any strictly conforming program. For example, a compiler might implement, as an extension, full evaluation of binary logical operators even though the C Standard specifies that evaluation stops as soon as the result can be determined. Such an extension does not conform to the C Standard because *side effects* in the right-hand operand of a logical AND operator would always occur, giving rise to a different behaviour.

## See also
Rule 1.1

---

Copyright The MISRA Consortium Limited © [Date - March 2025].