# Rule 1–0–2 (Document) Multiple compilers shall only be used if they have a common, defined interface.

## Amplification
[Implementation 7.5(1, 2, 9)]

## Rationale
“Multiple compilers” includes:
* Mixed languages;
* Different compilers;
* Different versions of the same compiler;
* Different configurations of the same compiler;

where “compiler” includes any tool used to translate source code or link object code.
If a module is to be implemented in a language other than C++, or compiled using a different C++ compiler, then it is essential to ensure that the module will integrate correctly with other modules. Some aspects of the behaviour of the C++ language are implementation-defined, and therefore these must be understood for the compiler being used. Examples of issues that need to be understood include:
* Stack usage;
* Parameter passing;
* The way in which data values are stored (lengths, alignments, aliasing, overlays etc.).

Note that this includes the use of extern "C".

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
