# Rule 10–1–2 (Required) A base class shall only be declared virtual if it is used in a diamond hierarchy.

## Rationale
The use of virtual base classes can introduce a number of undefined and potentially confusing behaviours. Therefore, a base class shall only be declared virtual if that base class is to be used as a common base class in a diamond hierarchy.

## Example
```c
class A {};
class B1: public virtual A {}; // Compliant – A is a common base for C
class B2: public virtual A {}; // Compliant – A is a common base for C
class C: public B1, B2 {};
class D: public virtual A {}; // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
