# Rule 10–1–3 (Required) An accessible base class shall not be both virtual and non-virtual in the same hierarchy.

## Rationale
If a base class is both virtual and non-virtual in a multiple inheritance hierarchy then there will be at least two copies of the base class sub-object in the derived object. This may not be consistent with developer expectations.

## Example
```c
class A {};
class B1: public virtual A {};
class B2: public virtual A {};
class B3: public A {};
class C: public B1, B2, B3 {}; // Non-compliant – 
 // C has two A sub-objects
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
