# Rule 16–2–2 (Required) C++ macros shall only be used for include guards, type qualifiers, or storage class specifiers.

## Rationale
These are the only permitted uses of macros. C++ offers const variable and function templates, which provide a type-safe alternative to the preprocessor.
Note that the use of macros for type qualifiers and storage class specifiers will break Rule 16–2–1.

## Example
```c
// The following are compliant 
#define STOR extern // storage class specifier 
 // Breaks Rule 16–2–1
// The following are non-compliant 
#define CLOCK (xtal/16) // Constant expression 
#define PLUS2(X) ((X) + 2) // Macro expanding to expression 
#define PI 3.14159F // use const object instead 
#define int32_t long // use typedef instead 
#define STARTIF if( // language redefinition 
#define INIT(value) {(value), 0, 0} // braced initializer 
#define HEADER "filename.h" // string literal
```

## See also
Rule 16–2–1

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
