# Rule 18–0–2 (Required) The library functions atof, atoi and atol from library <cstdlib> shall not be used.

## Category
Required

## Rationale
These functions have undefined behaviour associated with them when the string cannot be
converted.

## Example
```cpp
#include <cstdlib>
int32_t f ( const char_t * numstr ) 
{ 
 return atoi ( numstr ); // Non-compliant 
}
```

## See also
ISO/IEC 9899:1990 [16] §7.10.1

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
