# Rule 2–10–1 (Required) Different identifiers shall be typographically unambiguous.

## Rationale
Depending on the font used to display the character set, it is possible for certain glyphs to appear the same, even though the characters are different. This may lead to the developer confusing an identifier with another one.
To help reduce the chance of this, identifiers shall not differ by any combination of:
* Only a mixture of case;
* The presence or absence of the underscore character;
* The interchange of the letter “O”, and the number “0”;
* The interchange of the letter “I”, and the number “1”;
* The interchange of the letter “I”, and the letter “l” (el);
* The interchange of the letter “l” (el), and the number “1”;
* The interchange of the letter “S” and the number “5”;
* The interchange of the letter “Z” and the number “2”;
* The interchange of the letter “n” and the letter “h”;
* The interchange of the letter “B” and the number “8”;
* The interchange of the letter sequence “rn” (“r” followed by “n”) with the letter “m”.

## Example
```c
int32_t id1_a_b_c; 
int32_t id1_abc; // Non-compliant
int32_t id2_abc; // Non-compliant 
int32_t id2_ABC; // Non-compliant
int32_t id3_a_bc; 
int32_t id3_ab_c; // Non-compliant
int32_t id4_a_bc; 
int32_t id4_ab_c; // Non-compliant
int32_t id5_ii; 
int32_t id5_11; // Non-compliant
int32_t id6_i0; 
int32_t id6_1O; // Non-compliant
int32_t id7_in; 
int32_t id7_1h; // Non-compliant
int32_t id8_Z5; 
int32_t id8_2S; // Non-compliant
int32_t id9_ZS; 
int32_t id9_25; // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
