# Rule 4–5–1 (Required) Expressions with type bool shall not be used as operands to built-in operators other than the assignment operator =, the logical operators &&, ||, !, the equality operators == and !=, the unary & operator, and the conditional operator.

## Rationale
The use of bool operands with other operators is unlikely to be meaningful (or intended). This rule allows the detection of such uses, which often occur because the logical operators (&&, || and !) can be easily confused with the bitwise operators (&, | and ~).

## Example
```c
bool b1 = true; 
bool b2 = false; 
int8_t s8a;
if ( b1 & b2 ) // Non-compliant 
if ( b1 < b2 ) // Non-compliant 
if ( ~b1 ) // Non-compliant 
if ( b1 ^ b2 ) // Non-compliant 
if ( b1 == false ) // Compliant 
if ( b1 == b2 ) // Compliant 
if ( b1 != b2 ) // Compliant 
if ( b1 && b2 ) // Compliant 
if ( !b1 ) // Compliant 
s8a = b1 ? 3 : 7; // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
