# Rule 5–0–13 (Required) The condition of an if-statement and the condition of an iteration-statement shall have type bool.

## Rationale
If an expression with type other than bool is used in the condition of an if-statement or iteration-statement, then its result will be implicitly converted to bool. The condition expression shall contain an explicit test (yielding a result of type bool) in order to clarify the intentions of the developer.

## Exception
A condition of the form type-specifier-seq declarator is not required to have type bool.
This exception is introduced because alternative mechanisms for achieving the same effect are cumbersome and error-prone.

## Example
```c
extern int32_t * fn ( ); 
extern int32_t fn2 ( ); 
extern bool fn3 ( );
while ( int32_t * p = fn ( ) ) // Compliant by exception 
{ 
 // Code 
}
// The following is a cumbersome but compliant example 
do 
{ 
 int32_t * p = fn ( );
 if ( NULL == p ) 
 { 
 break; 
 } 
 // Code... 
} 
while ( true ); // Compliant
while ( int32_t length = fn2 ( ) ) // Compliant by exception 
{ 
 // Code 
}
while ( bool flag = fn3 ( ) ) // Compliant 
{ 
 // Code 
}
if ( int32_t * p = fn ( ) ) // Compliant by exception 
if ( int32_t length = fn2 ( ) ) // Compliant by exception 
if ( bool flag = fn3 ( ) ) // Compliant 
if ( u8 ) // Non-compliant 
if ( u8 && ( bool_1 <= bool_2 ) ) // Non-compliant 
for ( int32_t x = 10; x; --x ) // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
