# Rule 5–0–16 (Required) A pointer operand and any pointer resulting from pointer arithmetic using that operand shall both address elements of the same array.

## Amplification
[Undefined 5.7(5)]

## Rationale
This rule applies to expressions of the form:
* integer_expression + pointer_expression
* pointer_expression + integer_expression
* pointer_expression - integer_expression
* ++pointer_expression
* pointer_expression++
* --pointer_expression
* pointer_expression--
* pointer_expression [ integer_expression ]

where pointer_expression is a pointer to an array element.
It is undefined behaviour if the result obtained from one of the above expressions is not a pointer to an element of the array pointed to by pointer_expression or an element one beyond the end of that array.

## Example
```c
void f1 ( const int32_t * a1 ) 
{ 
 int32_t a2[ 10 ];
 const int32_t * p1 = &a1 [ 1 ]; // Non-compliant – a1 not an array 
 int32_t * p2 = &a2 [ 10 ]; // Compliant 
 int32_t * p3 = &a2 [ 11 ]; // Non-compliant 
}
void f2 ( ) 
{ 
 int32_t b; 
 int32_t c [ 10 ];
 f1 ( &b ); 
 f1 ( c ); 
}
```

## See also
Rule 5–0–15

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
