# Rule 5–0–4 (Required) An implicit integral conversion shall not change the signedness of the underlying type.

## Rationale
Some signed to unsigned conversions may lead to implementation-defined behaviour. This behaviour may not be consistent with developer expectations.

## Example
```c
void f() 
{ 
 int8_t s8; 
 uint8_t u8;
 s8 = u8; // Non-compliant 
 u8 = s8 + u8; // Non-compliant 
 u8 = static_cast< uint8_t > ( s8 ) + u8; // Compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
