# Rule 5–2–8 (Required) An object with integer type or pointer to void type shall not be converted to an object with pointer type.

## Amplification
[Unspecified 5.2.10(7)]

## Rationale
In general, converting from an integral type or a pointer to void type to a pointer to an object leads to unspecified behaviour.

## Example
```c
struct S 
{ 
 int32_t i; 
 int32_t j; 
};
void f ( void * v, int32_t i ) 
{ 
 S * s1 = reinterpret_cast< S * >( v ); // Non-compliant 
 S * s2 = reinterpret_cast< S * >( i ); // Non-compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
