# Rule 5–3–1 (Required) Each operand of the ! operator, the logical && or the logical || operators shall have type bool.

## Rationale
The use of operands with types other than bool with these operators is unlikely to be meaningful (or intended). This rule allows the detection of such uses, which often occur because the logical operators (&&, || and !) can be easily confused with the bitwise operators (&, | and ~).

## Example
```c
if ( ( a < b ) && ( c < d ) ) // Compliant 
if ( 1 && ( c < d ) ) // Non-compliant 
if ( ( a < b ) && ( c + d ) ) // Non-compliant
if ( u8_a && ( c + d ) ) // Non-compliant 
if ( !0 ) // Non-compliant – 
 // also breaks other rules 
if ( !ptr ) // Non-compliant 
if ( !false ) // Compliant with this rule, 
 // but breaks others
```

## See also
ISO/IEC 14882:2003 [1] §5.14, §5.15

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
