# Rule 6–6–4 (Required) For any iteration statement there shall be no more than one break or goto statement used for loop termination.

## Rationale
Restricting the number of exits from a loop is done in the interests of good structured programming. One break or goto statement is acceptable in a loop since this allows, for example, for dual outcome loops or optimal coding.

## Example
```c
for ( int32_t i = 0; i < 10; i++ ) 
{ 
 if ( ... ) 
 { 
 break; // Compliant 
 } 
}
while ( ... ) 
{ 
 if ( ... ) 
 { 
 break; // Compliant 
 } 
}
for ( int32_t i = 0; i < 10; i++ ) 
{ 
 if ( ... ) 
 { 
 break; 
 } 
 else if ( ... ) 
 { 
 break; // Non-compliant – second jump from loop 
 } 
 else 
 { 
 ... 
 } 
}
while ( ... ) 
{ 
 if ( ... ) 
 { 
 break; 
 } 
 if ( ... ) 
 { 
 break; // Non-compliant – second jump from loop 
 } 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
