# Rule 7–1–1 (Required) A variable which is not modified shall be const qualified.

## Rationale
If a variable does not need to be modified, then it shall be declared with const qualification so that it cannot be modified. A non-parametric variable will then require its initialization at the point of declaration. Also, future maintenance cannot accidentally modify the value.

## Example
```c
void b ( int32_t * );
int32_t f ( int32_t * p1, // Non-compliant 
 int32_t * const p2, // Compliant 
 int32_t * const p3 ) // Compliant 
{ 
 *p1 = 10; 
 *p2 = 10; 
 b( p3 );
 int32_t i = 0; // Non-compliant
 return i; 
}
```

## See also
ISO/IEC 14882:2003 [1] §7.1.5.1

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
