# Rule 7–3–4 (Required) using-directives shall not be used.

## Rationale
using-directives add additional scopes to the set of scopes searched during name lookup. All identifiers in these scopes become visible, increasing the possibility that the identifier found by the compiler does not meet developer expectations.
using-declarations or fully qualified names restricts the set of names considered to only the name explicitly specified, and so are safer options.

## Example
```c
namespace NS1 
{ 
 int32_t i1; 
 int32_t j1; 
 int32_t k1; 
}
using namespace NS1; // Non-compliant
namespace NS2 
{ 
 int32_t i2; 
 int32_t j2; 
 int32_t k2; 
}
using NS2::j2; // Compliant
namespace NS3 
{ 
 int32_t i3; 
 int32_t j3; 
 int32_t k3; 
}
void f () 
{ 
 ++i1; 
 ++j2; 
 ++NS3::k3; 
}
```
In the above, i1 is found via the using-directive. However, as a result of the using-directive, j1 and k1 are also visible. The using-declaration allows j2 to be found while i2 and k2 remain hidden. Finally, the qualified name NS3::k3 unambiguously refers to k3, and i3, j3 and k3 remain hidden to normal lookup.

## See also
ISO/IEC 14882:2003 [1] §7.3.4

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
