# Rule 7–5–4 (Advisory) Functions should not call themselves, either directly or indirectly.

## Rationale
Unbounded recursion is likely to lead to a stack over-flow and may impact system timings. This is also the case for an iterative algorithm.

## Example
```c
int32_t fn ( int32_t x ) 
{ 
 if ( x > 0 ) 
 { 
 x = x * fn ( x – 1 ); // Non-compliant 
 } 
 return ( x ); 
}
// File1.cpp 
int32_t fn_2 ( int32_t x ) 
{ 
 if ( x > 0 ) 
 { 
 x = x * fn_3 ( x – 1 ); // Non-compliant 
 } 
 return ( x ); 
}
// File2.cpp 
int32_t fn_3 ( int32_t x ) 
{ 
 if ( x == 0 ) 
 { 
 x = x * fn_2 ( x – 1 ); // Non-compliant 
 } 
 return ( x ); 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
