# Rule 9–3–3 (Required) If a member function can be made static then it shall be made static, otherwise if it can be made const then it shall be made const.

## Rationale
Declaring a member function static or const limits its access to the non-static data members. This helps to prevent unintentional modification of the data, and facilitates compliance with Rule 7–1–1.

## Example
```c
class A 
{ 
public: 
 int16_t f1 ( ) // Non-compliant – can be const 
 { 
 return m_i; 
 }
 int16_t f2 ( ) // Non-compliant – can be static 
 { 
 return m_s; 
 } 
 int16_t f3 ( ) // Compliant – cannot be const or static 
 { 
 return ++m_i; 
 } 
private: 
 int16_t m_i; 
 static int16_t m_s; 
};
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
