# Rule 11.6.2 The value of an object must not be read before it has been set

## Category
Mandatory

## Analysis
Undecidable, System

## Amplification
For the purposes of this rule, an array element or class member is considered to be a discrete object.
*Note:* `struct` members are also class members.

## Rationale
Objects created with *automatic storage duration* or *dynamic storage duration* have an *indeterminate
value*. Reading an *indeterminate value* may result in *undefined behaviour*.

This rule requires that all objects are written, either by implicit or explicit initialization in their
declaration or by assignment, before they are read.

*Note:* jumping over an initializer by the use of a `goto` or `switch` statement “bypasses” the declaration
of the object, rendering the program *ill-formed*.

## Example
```cpp
namespace
{
 int32_t Z; // Compliant - implicitly initialized with '0'
}

void f()
{
 int32_t i;
 int32_t j = i + 1; // Non-compliant - i has not been assigned a value

 int32_t * p = new int32_t;
 int32_t k = *p; // Non-compliant - *p has not been assigned a value

 int32_t * q;

 if ( q == p ) // Non-compliant - q has not been assigned a value
 {
 }
}

int32_t g( bool b )
{
 if ( b )
 {
 goto L1;
 }

 int32_t x;

 x = 10u;

L1:
 x = x + 1u; // Non-compliant - x may not have been assigned a value

 return x;
}

struct S { int32_t a; int32_t b; };

void h()
{
 S s1;
 S s2 = { 10 };

 auto i1 = s1.a; // Non-compliant
 auto i2 = s2.b; // Compliant - s2.b implicitly initialized to 0

 int32_t array1[ 10 ] = { 1, 2, 3 };
 int32_t array2[ 10 ];

 auto i3 = array1[ 5 ]; // Compliant - array1[ 5 ] implicitly initialized to 0
 auto i4 = array2[ 5 ]; // Non-compliant
}

class C
{
public:
 C() : m_a( 10 ), m_b( 7 ) // Both m_a and m_b initialized
 {
 }

 C( int32_t a ) : m_a( a ) // m_b not initialized
 {
 }

 int32_t GetmB()
 {
 return m_b;
 }

private:
 int32_t m_a;
 int32_t m_b;
};

int main()
{
 C c1;
 if ( c1.GetmB() > 0 ) // Compliant - m_b initialized
 {
 }

 C c2( 5 );

 if ( c2.GetmB() > 0 ) // Non-compliant - m_b not initialized
 {
 }
}
```

## See also
Rule 15.1.4

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
