# Rule 18.5.2 Program-terminating functions should not be used

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Amplification
A program should not contain calls to the C++ Standard Library functions `abort`, `exit`, `_Exit`,
`quick_exit` or `terminate`. Additionally, the address of any of these functions should not be taken.

## Rationale
If a program terminates due to a call to any of the functions listed above, then the stack will not be
unwound and object destructors will not be called. This will potentially leave the environment in an
undesirable state (e.g. a file permanently locked).

Taking the address of the functions is not recommended to prevent them from being called via a
function pointer.

*Notes:*
1. This rule only covers explicit calls to the termination functions. The majority of ways in which
they may be called implicitly are prevented by Rule 18.1.2, Rule 18.3.1 and Rule 18.5.1.
2. This rule aims to prevent program-terminating functions from being called without the system
level implications (such as unreleased resources) being duly considered. If the safety architecture
requires rapid termination on the detection of an error, then it may be appropriate to disapply
this rule.

## Exception
The call to `abort` that occurs due to the macro expansion of `assert` is not considered to be an
explicit call, as it is not expected to be reachable.

*Note:* a project may consider disallowing this exception if the behaviour of `abort` is not a suitable
response to a failed assertion, such as when there is no external mechanism to recover the terminated
program.

## See also
Rule 18.1.2, Rule 18.3.1, Rule 18.5.1

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
