# Rule 24.5.1 The character handling functions from <cctype> and <cwctype> shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule applies to the character classification functions and the character case mapping functions
from `<cctype>` and `<cwctype>`.

*Note:* this rule also applies to the same functions from `<ctype.h>` and `<wctype.h>`.

## Rationale
The functions declared within `<cctype>` support the classification and case mapping of characters.
*Undefined behaviour* occurs if these functions are called with arguments that are not representable
as an `unsigned char`, or that are not equal to the value of the macro `EOF`. Similar issues exist for
the functions provided by `<cwctype>`.

The C++ Standard Library provides equivalent classification and case mapping functions within
`<locale>` that are safer to use.

*Note:* the C++ Standard states that the behaviour of the functions covered by this rule is defined in
the related version of ISO 9899 [6].

## Example
```cpp
void f( char c )
{
 if ( std::isdigit( c ) ) {} // Non-compliant
 if ( std::isdigit( a, std::locale {} ) ) {} // Compliant version of the above
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
