# Rule 25.5.3 The pointer returned by the C++ Standard Library functions asctime, ctime, gmtime, localtime, localeconv, getenv, setlocale or strerror must not be used following a subsequent call to the same function

## Category
Mandatory

## Analysis
Undecidable, System

## Amplification
Calls to `setlocale` may change the values accessible through a pointer that was previously returned
by `localeconv`.

For the purposes of this rule:
*   A call to `setlocale` following a call to `localeconv` are treated as if they are calls to the same
function; and
*   Calls to `asctime` and `ctime` are treated as if they are calls to the same function; and
*   Calls to `gmtime` and `localtime` are treated as if they are calls to the same function.

*Note:* calls to `setlocale` or `localeconv` within a different thread of execution may lead to violations
of this rule.

## Rationale
The C++ Standard Library functions `asctime`, `ctime`, `gmtime`, `localtime`, `localeconv`, `getenv`,
`setlocale` and `strerror` return a pointer to an object within the library's implementation. The
implementation is permitted to use static buffers for any of these objects and a second call (which
may occur in a different thread) to the same function may modify the contents of the buffer. The value
accessed through a pointer held by the program before a subsequent call to a function may therefore
change unexpectedly.

*Note:* the C++ Standard states that the behaviour of the functions covered by this rule is specified in
the related version of ISO 9899 [6].

## Example
```cpp
void f1()
{
 const struct lconv * lc = localeconv();

 std::string copy { lc->int_curr_symbol };

 const char * res = std::setlocale ( LC_MONETARY, "fr_FR" );

 std::cout << lc->int_curr_symbol; // Non-compliant - use after setlocale called
 std::cout << copy; // Compliant - copy made before call
 std::cout << res; // Compliant - no subsequent call before use
}
```

## See also
Rule 25.5.1

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
