# Rule 5.7.3 Line-splicing shall not be used in `//` comments

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
This rule is applied in translation phase 2, after multibyte characters have been mapped to the basic
source character set during translation phase 1 (see [lex.phases]).

## Rationale
Line-splicing occurs when the `\` character is immediately followed by a new-line character. If a source
line containing a `//` comment ends with a `\` character in the basic source character set, the next line
becomes part of the comment. This may result in the unintentional removal of code.

## Example
In the following non-compliant example, the physical line containing the `if` keyword is logically part
of the previous line and is therefore part of a comment.
```cpp
void f( bool b )
{
  uint16_t x = 0U; // comment \
  if ( b )
  {
    ++x; // This is always executed
  }
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
