# Rule 10.7 If a composite expression is used as one operand of an operator in which the usual arithmetic conversions are performed then the other operand shall not have wider essential type

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
The rationale is described in the introduction on composite operators and expressions (see Section 8.10.3).

Restricting implicit conversions on composite expressions means that sequences of arithmetic operations within an expression must be conducted in exactly the same essential type. This reduces possible developer confusion.

Note: this does not imply that all operands in an expression are of the same essential type.

The expression u32a + u16b + u16c is compliant as both additions will notionally be performed in type uint32_t. In this case only non-composite expressions are implicitly converted.

The expression (u16a + u16b) + u32c is non-compliant as the left addition is notionally performed in type uint16_t and the right in type uint32_t, requiring an implicit conversion of the composite expression u16a + u16b to uint32_t.

## Example
The following are compliant:

```c
  u32a * u16a + u16b                    /* No composite conversion */
( u32a * u16a ) + u16b                  /* No composite conversion */
  u32a * ( ( uint32_t ) u16a + u16b )   /* Both operands of * have
                                         * same essential type     */
  u32a += ( u32b + u16b )               /* No composite conversion */
```

The following are non-compliant:

```c
  u32a * ( u16a + u16b )                /* Implicit conversion of ( u16a + u16b ) */
  u32a += ( u16a + u16b )               /* Implicit conversion of ( u16a + u16b ) */
```

## See also
Rule 10.4, Rule 10.6, Section 8.10.3

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
