# Rule 12.3 The comma operator should not be used

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
Use of the comma operator is generally detrimental to the readability of code, and the same effect can usually be achieved by other means.

## Example
```c
f ( ( 1, 2 ), 3 ); /* Non-compliant - how many parameters? */
```

The following example is non-compliant with this rule and other rules:

```c
for ( i = 0, p = &a[ 0 ]; i < N; ++i, ++p )
{
}
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
