# Rule 13.2 The value of an expression and its persistent side effects shall be the same under all permitted evaluation orders

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99

## Amplification
Between any two adjacent sequence points or within any full expression:
1.  No object shall be modified more than once;
2.  No object shall be both modified and read unless any such read of the object’s value contributes towards computing the value to be stored into the object;
3.  There shall be no more than one modification access with volatile-qualified type;
4.  There shall be no more than one read access with volatile-qualified type.

Note: An object might be accessed indirectly, by means of a pointer or a called function, as well as being accessed directly by the expression.

Note: This Amplification is intentionally stricter than the headline of the rule. As a result, expressions such as:

```c
x = x = 0;
```

are not permitted by this rule even though the value and the persistent side effects, provided that x is not volatile, are independent of the order of evaluation or side effects.

Sequence points are summarized in Annex C of both the C90 and C99 standards. The sequence points in C90 are a subset of those in C99.

Full expressions are defined in Section 6.6 of the C90 standard and Section 6.8 of the C99 standard.

## Rationale
The Standard gives considerable flexibility to compilers when evaluating expressions. Most operators can have their operands evaluated in any order. The main exceptions are:
*   Logical AND && in which the second operand is evaluated only if the first operand evaluates to non-zero;
*   Logical OR || in which the second operand is evaluated only if the first operand evaluates to zero;
*   The conditional operator ?: in which the first operand is always evaluated and then either the second or third operand is evaluated;
*   The , operator in which the first operand is evaluated and then the second operand is evaluated.

Note: The presence of parentheses may alter the order in which operators are applied. However, this does not affect the order of evaluation of the lowest-level operands, which may be evaluated in any order.

Many of the common instances of the unpredictable behaviour associated with expression evaluation can be avoided by following the advice given by Rule 13.3 and Rule 13.4.

## Examples
When the COPY_ELEMENT macro is invoked in this non-compliant example, i is read twice and modified twice. It is unspecified whether the order of operations on i is:
*   Read, modify, read, modify, or
*   Read, read, modify, modify.

```c
#define COPY_ELEMENT ( index ) ( a[( index )] = b[( index )] )

COPY_ELEMENT ( i++ );
```

In this non-compliant example the order in which v1 and v2 are read is unspecified.

```c
extern volatile uint16_t v1, v2;
uint16_t t;

t = v1 + v2;
```

In this compliant example PORT is read and modified.

```c
extern volatile uint8_t PORT;

PORT = PORT & 0x80u;
```

The order of evaluation of function arguments is unspecified as is the order in which side effects occur as shown in this non-compliant example.

```c
uint16_t i = 0;

/*
 * Unspecified whether this call is equivalent to:
 * f ( 0, 0 )
 * or f ( 0, 1 )
 */
f ( i++, i );
```

The relative order of evaluation of a function designator and function arguments is unspecified. In this non-compliant example, if the call to g modifies p then it is unspecified whether the function designator p->f uses the value of p prior to the call of g or after it.

```c
p->f ( g ( &p ) );
```

## See also
Dir 4.9, Rule 13.1, Rule 13.3, Rule 13.4

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
