# Rule 2.2 There shall be no dead code

## Category
Required

## Analysis
Undecidable, System

## Applies to
C90, C99

## Amplification
Any operation that is executed but whose removal would not affect program behaviour constitutes *dead code*. Operations that are introduced by language extensions are assumed always to have an effect on program behaviour.

Note: The behaviour of an embedded system is often determined not just by the nature of its actions, but also by the time at which they occur.

Note: *unreachable code* is not *dead code* as it cannot be executed.

## Rationale
The presence of *dead code* may be indicative of an error in the program’s logic. Since *dead code* may be removed by a compiler, its presence may cause confusion.

## Exception
A cast to *void* is assumed to indicate a value that is intentionally not being *used*. The cast is therefore not *dead code* itself. It is treated as using its operand which is therefore also not *dead code*.

## Example
In this example, it is assumed that the object pointed to by p is used in other functions.

```c
extern volatile uint16_t v;
extern char *p;

void f ( void )
{
  uint16_t x;

  ( void ) v;        /* Compliant - v is accessed for its side effect
                      * and the cast to void is permitted
                      * by exception */

  ( int32_t ) v;     /* Non-compliant - the cast operator is dead */

  v >> 3;            /* Non-compliant - the >> operator is dead */

  x = 3;             /* Non-compliant - the = operator is dead
                      * - x is not subsequently read */

  *p++;              /* Non-compliant - result of * operator is not used */

  ( *p )++;          /* Compliant - *p is incremented */
}
```

In the following compliant example, the `__asm` keyword is a language extension, not a function call operation, and is therefore not *dead code*:

```c
__asm ( "NOP" );
```

In the following example, the function g does not contain *dead code*, and is not itself *dead code* because it does not contain any operations. However, the call to the function is dead because it could be removed without affecting program behaviour.

```c
void g ( void )
{
  /* Compliant - there are no operations in this function */
}

void h ( void )
{
  g ( );             /* Non-compliant - the call could be removed */
}
```

## See also
Rule 17.7

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
