# Rule 21.9 The library functions *bsearch* and *qsort* of `<stdlib.h>` shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Amplification
The identifiers *bsearch* and *qsort* shall not be used and no macro with one of these names shall be
expanded.

## Rationale
If the comparison function does not behave consistently when comparing elements, or it modifies any
of the elements, the behaviour is undefined.

*Note*: the unspecified behaviour, which relates to the treatment of elements that compare as equal,
can be avoided by ensuring that the comparison function never returns 0. When two elements are
otherwise equal, the comparison function could return a value that indicates their relative order in
the initial array.

The implementation of *qsort* is likely to be recursive and will therefore place unknown demands on
stack resource. This is of concern in embedded systems as the stack is likely to be a fixed, often small,
size.

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
