# Rule 4.2 Trigraphs should not be used

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
Trigraphs are denoted by a sequence of two question marks followed by a specified third character (e.g. `??-` represents a `~` (tilde) character and `??)` represents a `]`). They can cause accidental confusion with other uses of two question marks.

Note: the so-called digraphs:

` <: :> <% %> %: %:%:`

are permitted because they are tokens. Trigraphs are replaced wherever they appear in the program prior to preprocessing.

## Example
For example the string

```c
"(Date should be in the form ??-??-??)"
```

would not behave as expected, actually being interpreted by the compiler as

```c
"(Date should be in the form ~~]"
```

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
