# Rule 5.9 Identifiers that define objects or functions with internal linkage should be unique

## Category
Advisory

## Analysis
Decidable, System

## Applies to
C90, C99

## Amplification
The identifier name should be unique across all name spaces and translation units. Any identifier used in this way should not have the same name as any other identifier, even if that other identifier denotes an object with no linkage.

## Rationale
Enforcing uniqueness of identifier names in this manner helps avoid confusion.

## Exception
An *inline function* with internal linkage may be defined in more than one translation unit provided that all such definitions are made in the same *header file* that is included in each translation unit.

## Example
In the following example, `file1.c` and `file2.c` are both part of the same project.

```c
/* file1.c */
static int32_t count;    /* "count" has internal linkage */

static void foo ( void ) /* "foo" has internal linkage */
{
  int16_t count;         /* Non-compliant - "count" has no linkage
                          * but clashes with an identifier with
                          * internal linkage */
  int16_t index;         /* "index" has no linkage */
}

void bar1 ( void )
{
  static int16_t count;  /* Non-compliant - "count" has no linkage
                          * but clashes with an identifier with
                          * internal linkage */
  int16_t index;         /* Compliant - "index" is not unique but
                          * has no linkage */
  foo ( );
}
/* End of file1.c */

/* file2.c */
static int8_t count;     /* Non-compliant - "count" has internal
                          * linkage but clashes with other
                          * identifiers of the same name */

static void foo ( void ) /* Non-compliant - "foo" has internal
                          * linkage but clashes with a function of
                          * the same name */
{
  int32_t index;         /* Compliant - both "index" and "nbytes" */
  int16_t nbytes;        /* are not unique but have no linkage */
}

void bar2 ( void )
{
  static uint8_t nbytes; /* Compliant - "nbytes" is not unique but
                          * has no linkage and the storage class is
                          * irrelevant */
}
/* End of file2.c */
```

## See also
Rule 8.10

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
