# Rule 6.2 Single-bit named bit fields shall not be of a signed type

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99

## Rationale
According to the C99 Standard Section 6.2.6.2, a single-bit signed bit-field has a single (one) sign bit and no (zero) value bits. In any representation of integers, 0 value bits cannot specify a meaningful value.

A single-bit signed bit-field is therefore unlikely to behave in a useful way and its presence is likely to indicate programmer confusion.

Although the C90 Standard does not provide so much detail regarding the representation of types, the same considerations apply as for C99.

Note: this rule does not apply to unnamed bit fields as their values cannot be accessed.

---

Copyright The MISRA Consortium Limited © [Date - March 2013].
