# Rule 11.1 Conversions shall not be performed between a pointer to a function and any other type
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
A pointer to a function shall only be converted into or from a pointer to a function with a compatible type.
## Rationale
The conversion of a pointer to a function into or from any of:
- Pointer to object;
- Pointer to incomplete;
- *void \**
results in undefined behaviour.
If a function is called by means of a pointer whose type is not compatible with the called function, the behaviour is undefined. Conversion of a pointer to a function into a pointer to a function with a different type is permitted by the C Standard. Conversion of an integer into a pointer to a function is also permitted by the C Standard. However, both are prohibited by this rule in order to avoid the undefined behaviour that would result from calling a function using an incompatible pointer type.
## Exception
1. A *null pointer constant* may be converted into a pointer to a function;
2. A pointer to a function may be converted into *void*;
3. A function type may be implicitly converted into a pointer to that function type.
Note: exception 3 covers the implicit conversions that commonly occur when:
- A function is called directly, i.e. using a function identifier to denote the function to be called;
- A function is assigned to a function pointer.
## Example
```c
typedef void ( *fp16 ) ( int16_t n );
typedef void ( *fp32 ) ( int32_t n );

#include <stdlib.h> /* To obtain macro NULL */

fp16 fp1 = NULL; /* Compliant - exception 1 */
fp32 fp2 = ( fp32 ) fp1; /* Non-compliant - function
 * pointer into different
 * function pointer */

if ( fp2 != NULL ) /* Compliant - exception 1 */
{
}

fp16 fp3 = ( fp16 ) 0x8000; /* Non-compliant - integer into
 * function pointer */
fp16 fp4 = ( fp16 ) 1.0e6F; /* Non-compliant - float into
 * function pointer */

/* In the following example, the function call returns a pointer to a function type. Casting the return value into void is compliant with this rule. */
typedef fp16 ( *pfp16 ) ( void );
pfp16 pfp1;
( void ) ( *pfp1 ( ) ); /* Compliant - exception 2 - cast function
 * pointer into void */

/* The following examples show compliant implicit conversions from a function type into a pointer to that function type. */
extern void f ( int16_t n );

f ( 1 ); /* Compliant - exception 3 - implicit conversion
 * of f into pointer to function */
fp16 fp5 = f; /* Compliant - exception 3 */
```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
