# Rule 18.9 An object with temporary lifetime shall not undergo array-to-pointer conversion
## Category
Required
## Analysis
Decidable, Single Translation Unit
## Applies to
C90, C99, C11
## Amplification
*Temporary lifetime* is a storage duration which describes the lifetime of the elements of non-*lvalue* arrays.
An array which is a member of a non-*lvalue* expression with structure or union type shall not be used as a value, other than as the immediate *postfix-expression* operand to a subscript operator.
The subscript operator shall not be used to produce a modifiable *lvalue*.
## Rationale
An array object can be a member of a structure or union, and therefore form part of the result value of any value expression. Because arrays used in an expression are always value-converted to a pointer to their elements, it is possible to form a pointer to such array sub-objects even when they are not part of a declared object with normal lifetime.
Modifying elements of such an array implicitly results in undefined behaviour in C90, and explicitly results in undefined behaviour in C99 and later. Accessing the elements of such an array after the end of its lifetime results in undefined behaviour, which is implicitly limited to the next sequence point in C90 and C99 (meaning the pointer cannot be stored or passed to any function), and to the duration of the complete containing expression in C11 and later.
The pointer will not be to const-qualified elements unless the array element type is const-qualified; therefore the array's type may appear to allow modification, and the generation of apparently modifiable element *lvalues*, even though the array itself has *temporary lifetime*.
Since the containing object can always be assigned to a named intermediate object by value, there is little reason to ever attempt to take the address of the value with temporary lifetime.
## Example
```c
/* Value object containing an array as an element */
struct S1 {
 int32_t array[10];
};

struct S1 s1;
struct S1 getS1 (void);
void foo(int32_t const * p);

/* Compliant - not temporary storage duration */
int32_t * p = s1.array;
s1.array[0] = 1;
foo( s1.array );

/* Non-compliant - temporary storage duration */
p = getS1().array; /* also creates dangling pointer */
foo( getS1().array );
foo( (s1 = s1).array ); /* other forms of non-lvalue expression */

/* Compliant - immediate element access is always safe */
int32_t j = getS1().array[3]; /* element copied: const access */
j = (s1 = s1).array[3];

/* Non-compliant - element used as a modifiable lvalue */
getS1().array[3] = j;
(1 ? s1 : s1).array[3] = j;
```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
