# Rule 22.16 All mutex objects locked by a thread shall be explicitly unlocked by the same thread

## Category
Required

## Analysis
Undecidable, System

## Applies to
C11

## Amplification
If a mutex object *mtx* is locked by *mtx_lock(mtx)* at a program point *p* there shall be an explicit
*mtx_unlock(mtx)* for mutex object *mtx* on all programs paths reachable from *p* before exiting the
thread.

## Rationale
When a thread terminates without releasing a lock, that lock may be held for indeterminate time. If
the life range of a mutex object ends while there are threads waiting for it the behaviour is
undefined.

Destroying a mutex on which threads are waiting is undefined behaviour.

Note: it is good practice to unlock mutexes in the same function and under the same control
dependencies in which they have been locked.

## Example
```c
mtx_t Ra;
mtx_t Rb;

int32_t t1( void *ignore ) /* Thread 1 */
{
 bool_t b;
 mtx_lock ( &Ra ); /* Compliant */
 mtx_unlock( &Ra );

 mtx_lock ( &Rb ); /* Non-compliant - unlock missing on one path */
 if ( b )
 {
 mtx_unlock( &Rb );
 }
 return 0;
}
```

## See also
Dir 4.13, Rule 22.1

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
