# Rule 4.1 Octal and hexadecimal escape sequences shall be terminated

## Category

Required

## Analysis

Decidable, Single Translation Unit

## Applies to

C90, C99, C11

## Amplification

An octal or hexadecimal escape sequence shall be terminated by either:
* The start of another escape sequence, or
* The end of the character constant or the end of a string literal. 

## Rationale

There is potential for confusion if an octal or hexadecimal escape sequence is followed by other characters. For example, the character constant `'\x1f'` consists of a single character whereas the character constant `'\x1g'` consists of the two characters `'\x1'` and `'g'`. The manner in which multi-character constants are represented as integers is implementation-defined.

The potential for confusion is reduced if every octal or hexadecimal escape sequence in a character constant or string literal is terminated. 

## Example

In this example, each of the strings pointed to by s1, s2 and s3 is equivalent to "Ag":

```c
const char *s1 = "\x41g"; /* Non-compliant - terminated by end of literal */
const char *s2 = "\x41""g"; /* Compliant - terminated by end of literal */
const char *s3 = "\x41\x67"; /* Compliant - terminated by another escape */

int c1 = '\141t'; /* Non-compliant */
int c2 = '\141\t'; /* Compliant - terminated by another escape */

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
