# Rule 8.14 The restrict type qualifier shall not be used

## Category

Required

## Analysis

Decidable, Single Translation Unit

## Applies to

C99, C11

## Rationale

When used with care the `restrict` type qualifier may improve the efficiency of code generated by a compiler. It may also allow improved static analysis. However, to use the `restrict` type qualifier the programmer must be sure that the memory areas operated on by two or more pointers do not overlap. There is a significant risk that a compiler will generate code that does not behave as expected if `restrict` is used incorrectly. 

## Example

The following example is compliant because the MISRA C Guidelines do not apply to the Standard Library functions. The programmer must ensure that the areas defined by `p`, `q` and `n` do not overlap.

```c
#include <string.h>
void f (void)
{
    /* memcpy has restrict-qualified parameters */
    memcpy (p, q, n);
}

```

The following example is non-compliant because a function has been defined using `restrict`.

```c
void user_copy (void * restrict p, void * restrict q, size_t n)
{
}

```

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
