# Rule 8.15 All declarations of an object with an explicit alignment specification shall specify the same alignment

## Category

Required

## Analysis

Decidable, System

## Applies to

C11

## Amplification

If any declaration (including the definition) of an object includes an explicit alignment specification, all other declarations of the same object shall also include the same explicit alignment specification. Two alignment specifications are the same if they are lexically identical after macro expansion. This rule applies both to alignments specified directly by an expression, and by naming a type. 

## Rationale

If multiple declarations of an object with external linkage have conflicting alignment specifications, the behaviour is undefined. Therefore, if the alignment of the object is important, it should be listed explicitly in order to avoid the risk of creating conflicting declarations in multiple translation units. If the alignment of the object does not need to be set explicitly, the alignment specification should be omitted entirely to avoid confusion.

Since an object with internal linkage is only accessible by name from within a single translation unit, there is no direct risk of incompatible alignment specifications causing undefined behaviour. However, this rule reduces the risk of accidentally introducing undefined behaviour during maintenance if the code is later modified to give an object external linkage instead.

If the alignment operand is a type name and the alignment specifications do not consistently use that same type name, there is a risk of introducing inconsistency if the configuration changes, such as if code is recompiled on a different platform with different fundamental type alignments. 

## Example

```c
/* header.h #included by both file1.c and file2.c */
extern alignas (16) int32_t a;
extern alignas (0) int32_t b;
extern int32_t c;
extern int32_t d;
extern alignas (16) int32_t e;
extern alignas (16) int32_t f;
extern int32_t g;
extern alignas (float) int32_t i;
extern alignas (float) int32_t j;
extern alignas (float) int32_t k;
extern alignas (float32_t) int32_t m;

/* file1.c */
alignas (16) int32_t a; /* Compliant - same explicit alignment */
alignas (16) int32_t b; /* Non-compliant - not consistently explicit */
alignas (16) int32_t c; /* Non-compliant - not consistently explicit */
alignas (16) int32_t d; /* Non-compliant - not consistently explicit */
int32_t e; /* Non-compliant */
alignas (16) int32_t f; /* Compliant - not manually aligned */
extern alignas (16) int32_t g; /* Non-compliant because of file2.c */
alignas (float) int32_t i; /* Compliant - same type used */
alignas (double) int32_t j; /* Non-compliant - different type, and therefore may be a constraint violation */
alignas (4) int32_t k; /* Non-compliant - regardless of the size of float */
alignas (float32_t) int32_t m; /* Compliant - same type used by name */

/* file2.c */
extern int32_t f; /* Non-compliant - not consistent with either file1.c or header.h */
extern alignas (8) int32_t g; /* Non-compliant - undefined behaviour because of inconsistency with file1.c */

```

## See also

Rule 8.6, Rule 8.16, Rule 8.17

---

Copyright The MISRA Consortium Limited © [Date - April 2023].
